﻿using System.Collections.Generic;
using System.Runtime.Serialization;

namespace VA.PPMS.IWS.Common
{
    [DataContract]
    public class County
    {
        [DataMember]
        public string name { get; set; }

        [DataMember]
        public string countyFipsCode { get; set; }
    }

    [DataContract]
    public class StateProvince
    {
        [DataMember]
        public string name { get; set; }

        [DataMember]
        public string code { get; set; }
    }

    [DataContract]
    public class Country
    {
        [DataMember]
        public string name { get; set; }

        [DataMember]
        public string code { get; set; }

        [DataMember]
        public string fipsCode { get; set; }

        [DataMember]
        public string iso2Code { get; set; }

        [DataMember]
        public string iso3Code { get; set; }
    }

    [DataContract]
    public class Address
    {
        [DataMember]
        public string addressLine1 { get; set; }

        [DataMember]
        public string addressLine2 { get; set; }

        [DataMember]
        public string addressLine3 { get; set; }

        [DataMember]
        public string city { get; set; }

        [DataMember]
        public Country country { get; set; }

        [DataMember]
        public County county { get; set; }

        [DataMember]
        public string internationalPostalCode { get; set; }

        [DataMember]
        public StateProvince stateProvince { get; set; }

        [DataMember]
        public string zipCode4 { get; set; }

        [DataMember]
        public string zipCode5 { get; set; }
    }

    [DataContract]
    public class Geocode
    {
        [DataMember]
        public string calcDate { get; set; }

        [DataMember]
        public double locationPrecision { get; set; }

        [DataMember]
        public double latitude { get; set; }

        [DataMember]
        public double longitude { get; set; }
    }

    [DataContract]
    public class AddressMetaData
    {
        [DataMember]
        public string addressType { get; set; }

        [DataMember]
        public int confidenceScore { get; set; }

        [DataMember]
        public string deliveryPointValidation { get; set; }

        [DataMember]
        public List<string> nonPostalInputData { get; set; }

        [DataMember]
        public string residentialDeliveryIndicator { get; set; }
    }

    [DataContract]
    public class Message
    {
        [DataMember]
        public string code { get; set; }

        [DataMember]
        public string key { get; set; }

        [DataMember]
        public bool potentiallySelfCorrectingOnRetry { get; set; }

        [DataMember]
        public string severity { get; set; }

        [DataMember]
        public string text { get; set; }
    }

    [DataContract]
    public class RootObjectRequest
    {
        [DataMember]
        public Address requestAddress { get; set; }

        [DataMember]
        public AddressMetaData addressMetaData { get; set; }

        [DataMember]
        public Geocode geocode { get; set; }

        [DataMember]
        public List<Message> messages { get; set; }
    }

    [DataContract]
    public class RootObjectResponse
    {
        [DataMember]
        public Address address { get; set; }

        [DataMember]
        public Geocode geocode { get; set; }

        [DataMember]
        public AddressMetaData addressMetaData { get; set; }
    }
}